function C = mymatmult(A,B)
% mymatmult performs matrix multiplication
% It returns an empty vector if the matrix
%  multiplication cannot be performed
% Format: mymatmult(matA, matB)
 
[m, n] = size(A);
[nb, p] = size(B);
if n ~= nb
    C = [];
else
    % Preallocate C
    C = zeros(m,p);
    % Outer 2 loops iterate through the elements in C
    %   which has dimensions m by p
    for i=1:m
        for j = 1:p
            % Inner loop performs the sum for each
            %  element in C
            mysum = 0;
            for k = 1:n
                mysum = mysum + A(i,k) * B(k,j);
            end
            C(i,j) = mysum;
        end
    end
end
